<?php
include('libraryPHP/site_config.php');
include('libraryPHP/session_check_url.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <title><?php echo $appName ?> | <?php echo $pageTitle ?></title>
    <?php echo $appFaviconHtml ?>
    <!-- theme css start -->
    <?php include("commoncss.php"); ?>
    <!-- theme css end -->
</head>

<body>
    <!-- Main Wrapper -->
    <div class="main-wrapper">
        <!-- Header start  -->
        <?php include("header.php"); ?>
        <!-- /Header end -->
        <!-- Sidebar -->
        <?php include("sidebar.php"); ?>
        <!-- /Sidebar -->
        <!-- Page Wrapper -->
        <div class="page-wrapper">
            <div class="content container-fluid">
                <!-- Page Header -->
                <div class="page-header">
                    <div class="row">
                        <div class="col">
                            <h3 class="page-title">Reported User </h3>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item active">Reported User</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- /Page Header -->
                <!-- start write start -->
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" id="user_report_form">
                            <div class="row">
                                <input type="hidden" name="action" id="action" value="show_tabular_report_user" required>
                                <div class="col-md-5">
                                    <label>From Date</label>
                                    <input type="date" id="s_date" max="9999-12-31" class="form-control" placeholder="From Date" value="" name="s_date">
                                    <label id="s_date-error" class="error" for="s_date"></label>
                                </div>
                                <div class="col-md-5">
                                    <label>To Date</label>
                                    <input type="date" id="e_date" class="form-control" max="9999-12-31" placeholder="To Date" value="" name="e_date">
                                    <label id="e_date-error" class="error" for="e_date"></label>
                                </div>
                                <div class="col-md-2" style="margin-top: 28px; ">
                                    <input type="submit" name="submit" class="btn btn-primary btn-rounded" value="Search">
                                </div>
                            </div>
                        </form>
                        <!-- horizontal Basic Forms End -->
                    </div>
                    <div class="col-md-12 top-20 padding-0" id="showtraveler" style="display:none; padding-top: 20px;">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="mb-2">Reported List</h3>

                                </div>
                                <div class="card-body">
                                    <div class="table-responsive" style="padding: 20px;">

                                        <table id="table_users" class="table table-striped table-bordered nowrap" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <th>S.No.</th>
                                                   
                                                    <th>Reported By</th>
                                                    <th>Reported To</th>
                                                    <th>Report Reason</th>
                                                    <th>Report Date & Time</th>

                                                </tr>
                                            </thead>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- start write end -->
            </div>
        </div>
        <!-- /Page Wrapper -->
        <!-- footer start -->
        <?php include("footer.php"); ?>
        <!-- footer end -->
    </div>
    <!-- /Main Wrapper -->
    <!-- sctipt start  -->

    <?php include('commonjs.php') ?>
    <?php include_once('extrajs.php') ?>
</body>

</html>
<!-- extra js -->

<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.colVis.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/rowgroup/1.0.4/js/dataTables.rowGroup.min.js"></script>
<script src="https://cdn.datatables.net/select/1.2.7/js/dataTables.select.min.js"></script>
<script src="https://cdn.datatables.net/fixedheader/3.1.5/js/dataTables.fixedHeader.min.js"> </script>
<script>
    var table = '';
    $(document).ready(function() {

        $('#table_users').DataTable();



    });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $(function() {
            jQuery.validator.addMethod("greaterThan",
                function(value, element, params) {
                    if (!/Invalid|NaN/.test(new Date(value))) {
                        return new Date(value) >= new Date($(params).val());
                    }
                    return isNaN(value) && isNaN($(params).val()) ||
                        (Number(value) >= Number($(params).val()));
                }, 'Must be greater than From date.');
            // Initialize form validation on the registration form.
            // It has the name attribute "registration"
            $("#user_report_form").validate({
                // Specify validation rules
                rules: {
                    // The key name on the left side is the name attribute
                    // of an input field. Validation rules are defined
                    // on the right side
                    s_date: "required",
                    e_date: {
                        required: true,
                        greaterThan: "#s_date"
                    },


                },
                // Specify validation error messages
                messages: {
                    s_date: "Please enter from date",
                    e_date: {
                        required: "Please enter to date"
                    }
                },
                // Make sure the form is submitted to the destination defined
                // in the "action" attribute of the form when valid
                submitHandler: function(form) {
                    /*form.submit();*/
                    var link = URLAPI + 'report_controller.php';
                    //var data=$(form).serialize();
                    var data = new FormData($(form)[0]);
                    var messsage = msgLoading.blankMessage[language];
                    console.log('messsage', messsage);
                    apiRequest.postFile(link, data, messsage).then(function(obj) {
                        console.log('obj', obj);
                        if (obj.success === true) {
                            var user_arr = obj.user_arr;
                            console.log('user_arr', user_arr);
                            if (user_arr.length > 0) {
                                $('#showtraveler').show();
                                $('#table_users').DataTable({
                                    data: user_arr,
                                    "destroy": true,
                                    "paging": true,
                                    "lengthChange": true,
                                    "searching": true,
                                    "ordering": true,
                                    "info": true,
                                    "autoWidth": false,
                                    "responsive": true,
                                    "aaSorting": [
                                        [0, "asc"]
                                    ],
                                    "bJQueryUI": "true",
                                    "sPaginationType": "full_numbers",
                                    "iDisplayLength": 5,
                                    "aLengthMenu": [
                                        [5, 10, 25, 50, 100, 200, -1],
                                        [5, 10, 25, 50, 100, 200, "All"]
                                    ],
                                    "columns": [{
                                            "data": "srno"
                                        },
                                      
                                        {
                                            "data": "reportedBy"
                                        },
                                        {
                                            "data": "reportedTo"
                                        },
                                        { "data": "reason" },
                                       
                                        {
                                            "data": "createtime"
                                        },
                                    ],

                                    dom: 'Blfrtip',
                                    buttons: [{
                                        extend: 'excel',
                                        text: 'Export to Excel',
                                        title: 'Safe Love App - User Report List',
                                        footer: true,
                                        exportOptions: {
                                            columns: [0, 1,2, 3, 4]
                                        }
                                    }]


                                });
                            } else {
                                $('#showtraveler').hide();
                                var title = msgTitleOperation.blankMessage[language];
                                var messsage = obj.msg[language];
                                msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                                swal({
                                    title: title,
                                    text: messsage,
                                    icon: "error", //error, success, info
                                    button: "Ok",
                                }).then((value) => {
                                    window.location.href = "#";
                                });
                            }
                        } else {
                            //------------ Operation Message --------------------
                            var title = msgTitleOperation.blankMessage[language];
                            var messsage = obj.msg[language];
                            msgSuccessErrorHtml.error(title, messsage, msgSuccessErrorHtmlSelector);
                            //------------ Operation Message End--------------------
                            return false;
                        }
                    }, function(err) {
                        console.log('err', err);
                        //alert('Server not responde');

                        //------------ Operation Message --------------------
                        var title = msgTitleOperation.errorOnServer[language];
                        var messsage = msgOperations.errorOnServer[language];
                        msgSuccessErrorHtml.warning(title, messsage, msgSuccessErrorHtmlSelector);
                        //------------ Operation Message End--------------------
                        return false;
                    });
                }
            });
        });
    });
</script>

</body>

</html>